#include "hal_base.h"
#include "hal_gpio.h"
#include "hal_t10.h"
#include "hal_irq.h"


uint8_t loop;			// ִдͳ
uint16_t value = 0;		//T10Timerֵ

/* ʼPA4 T10CKI˿ںPA5˿ڣPA4PA5̽*/
void GPIO_init(void)
{
	gpio_init_t init;
	init.io = GPIO_INPUT;
	init.level = GPIO_LOW_LEVEL;
	init.mode = GPIO_DIGIT_MODE;
	init.pu = DISABLE;
	init.pd = DISABLE;
	init.drive = GPIO_LOW_DRIVER;
	init.od = DISABLE;
	init.smit = GPIO_1_5_TO_3_0_SMIT;
	init.cur_ctr = DISABLE;
	gpio_init(PA_TYPE, GPIO_PIN_4, &init);

	init.io = GPIO_OUTPUT;
	gpio_init(PA_TYPE, GPIO_PIN_5, &init);

}

/* PA5ģʱ룬T10Ϊʱʹ */
void simu_clock(void)
{
	while (1) {
		gpio_write_pin(PA_TYPE, GPIO_PIN_5, 1);
		delay(5);
		gpio_write_pin(PA_TYPE, GPIO_PIN_5, 0);
		delay(5);
		CLRWDT();
	}

}

/* жϷT10жʱжϱ־ͳƽ */
void isr(void) interrupt
{
	if (irq_get_it_status(T10IE_IT) && irq_get_flag_status(T10IE_IT)) {
		irq_clear_flag_status(T10IE_IT);
		loop++;
	}	
}

void main() 
{
	// T10ʼṹ
	t10_init_t t_init;

	// RAMʼ
	ram_clear();
	// clockʼѡHRC,Ƶʹclock 
	clock_init(CLOCK_SRC_HRC, CLOCK_DIV_1, DISABLE);
	// GPIOڳʼ
	GPIO_init();

	// ʼT10Ϊģʽʱؼ */
	t_init.mode = T10_COUNT_MODE;
	t_init.cnt_mode = T10_UP_CNT;
	t_init.pre_func = ENABLE;
	t_init.prs = T10_CLK_DIV_2;
	t10_init(&t_init);

	// ʹж
	IRQ_GIE_CFG(1);
	// ʹT10ж
	irq_config(T10IE_IT, ENABLE);

	// T10
	t10_start();

	/* ģʱӹܣж */
	//simu_clock();

	while (1) {
		/* ģһʱ */
		gpio_write_pin(PA_TYPE, GPIO_PIN_5, 1);
		delay(5);
		gpio_write_pin(PA_TYPE, GPIO_PIN_5, 0);
		delay(5);
		/* T10Ƿһμ */
		value = t10_get_value();
		// ι
		CLRWDT();
	}
}